package jamezo97.clonecraft;

import jamezo97.clonecraft.block.BlockAntenna;
import jamezo97.clonecraft.block.BlockCentrifuge;
import jamezo97.clonecraft.block.BlockDNASequencer;
import jamezo97.clonecraft.block.BlockGeneExtractor;
import jamezo97.clonecraft.block.BlockLifeInducer;
import jamezo97.clonecraft.block.BlockSterilizer;
import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.item.ItemEmptyEgg;
import jamezo97.clonecraft.item.ItemEntitySequencePaper;
import jamezo97.clonecraft.item.ItemGene;
import jamezo97.clonecraft.item.ItemNeedle;
import jamezo97.clonecraft.item.ItemSpawnEgg;
import jamezo97.clonecraft.item.ItemTestTube;
import jamezo97.clonecraft.network.NetworkHandler;
import jamezo97.clonecraft.recipe.CloneCraftCraftingHandler;
import jamezo97.clonecraft.recipe.CreativeTabCloneCraft;
import jamezo97.clonecraft.recipe.RecipeAddGeneToSerum;
import jamezo97.clonecraft.recipe.RecipeAddGenes;
import jamezo97.clonecraft.recipe.RecipeClearDNAItem;
import jamezo97.clonecraft.recipe.RecipeEmptyEggToSpawnEgg;
import jamezo97.clonecraft.recipe.RecipeGeneDNA;
import jamezo97.clonecraft.recipe.RecipeMutateSerum;
import jamezo97.clonecraft.recipe.RecipeNeedleTestTubeRecipe;
import jamezo97.clonecraft.recipe.RecipeTestTubeNeedle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map.Entry;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.CCEntityPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(version = "1.2", modid = "CloneCraft", name = "CloneCraft")
@NetworkMod(clientSideRequired = true, serverSideRequired = false, channels={"CloneCraftClient", "CloneCraftServer"}, packetHandler=NetworkHandler.class)
public class CloneCraft {

	//	Extract single amounts of blood from entities.
	//	DNA sequencer - Enables you to sequence all the genes in an entity.
	//	DNA splicer - Allows you to splice genes into DNA samples to create mutated monsters


	public long ticks = 0;

	CreativeTabs CloneCraftTab = new CreativeTabCloneCraft("CloneCraft");

	@SidedProxy(modId = "CloneCraft", clientSide="jamezo97.clonecraft.ClientProxy", serverSide="jamezo97.clonecraft.CommonProxy")
	public static CommonProxy proxy;

	public static int cloneId = 178;


	public static ItemNeedle needle = null;

	public static Item testTube = null;

	public static Item emptyEgg = null;

	public static Item spawnEgg = null;

	public static Item gene = null;

	public static Item dnaData = null;

	public void loadItems(){
		needle = (ItemNeedle)new ItemNeedle(config.ITEM_NEEDLE_ID).setUnlocalizedName("needle").setCreativeTab(CloneCraftTab);
		testTube = new ItemTestTube(config.ITEM_TESTTUBE_ID).setUnlocalizedName("testTube").setCreativeTab(CloneCraftTab);

		emptyEgg = new ItemEmptyEgg(config.ITEM_EMPTYEGG_ID).setUnlocalizedName("emptyEgg").setCreativeTab(CloneCraftTab).setTextureName("CloneCraft:spawnEggOut");

		spawnEgg = new ItemSpawnEgg(config.ITEM_SPAWNEGG_ID).setUnlocalizedName("spawnEgg").setCreativeTab(CloneCraftTab);

		gene = new ItemGene(config.ITEM_GENE_ID).setUnlocalizedName("gene").setCreativeTab(CloneCraftTab);

		dnaData = new ItemEntitySequencePaper(config.ITEM_DNADATA_ID).setUnlocalizedName("dnaData").setCreativeTab(CloneCraftTab);

		GameRegistry.registerItem(needle, "needle");
		GameRegistry.registerItem(testTube, "testTube");
		GameRegistry.registerItem(emptyEgg, "emptyEgg");
		GameRegistry.registerItem(spawnEgg, "spawnEgg");



		LanguageRegistry.addName(emptyEgg, "Empty Egg");
	}



	public static BlockCentrifuge centrifuge;

	public static BlockSterilizer sterilizer;

	public static BlockLifeInducer lifeInducer;

	public static BlockDNASequencer dnaSequencer;

	public static BlockGeneExtractor geneExtractor;

	public static BlockAntenna antenna;

	public void loadBlocks(){
		centrifuge = (BlockCentrifuge) new BlockCentrifuge(config.BLOCK_CENTRIFUGE_ID).setUnlocalizedName("centrifuge").setStepSound(Block.soundMetalFootstep).setHardness(3.5f).setCreativeTab(CloneCraftTab);
		sterilizer = (BlockSterilizer) new BlockSterilizer(config.BLOCK_STERILIZER_ID).setUnlocalizedName("sterilizer").setStepSound(Block.soundMetalFootstep).setHardness(3.5f).setCreativeTab(CloneCraftTab);
		lifeInducer = (BlockLifeInducer) new BlockLifeInducer(config.BLOCK_TRANSMOGRIFIER_ID).setUnlocalizedName("lifeinducer").setStepSound(Block.soundMetalFootstep).setHardness(3.5f).setCreativeTab(CloneCraftTab);		
		antenna = (BlockAntenna) new BlockAntenna(config.BLOCK_ANTENNA_ID).setUnlocalizedName("antenna").setStepSound(Block.soundMetalFootstep).setHardness(3.5f).setCreativeTab(CloneCraftTab);	
		dnaSequencer = (BlockDNASequencer) new BlockDNASequencer(config.BLOCK_SEQUENCER_ID).setUnlocalizedName("dnaSequencer").setStepSound(Block.soundMetalFootstep).setHardness(3.5f).setCreativeTab(CloneCraftTab);	
		geneExtractor = (BlockGeneExtractor) new BlockGeneExtractor(config.BLOCK_GENEEXTRACTOR_ID).setUnlocalizedName("chromosomeExtractor").setStepSound(Block.soundMetalFootstep).setHardness(3.5f).setCreativeTab(CloneCraftTab);	


		GameRegistry.registerBlock(centrifuge, "centrifuge");
		LanguageRegistry.addName(centrifuge, "Centrifuge");

		GameRegistry.registerBlock(sterilizer, "sterilizer");
		LanguageRegistry.addName(sterilizer, "Sterilizer");

		GameRegistry.registerBlock(lifeInducer, "lifeInducer");
		LanguageRegistry.addName(lifeInducer, "Life Transmogrifier");

		GameRegistry.registerBlock(antenna, "antenna");
		LanguageRegistry.addName(antenna, "Antenna");

		GameRegistry.registerBlock(dnaSequencer, "dnaSequencer");
		LanguageRegistry.addName(dnaSequencer, "DNA Sequencer");

		GameRegistry.registerBlock(geneExtractor, "geneExtractor");
		LanguageRegistry.addName(geneExtractor, "Gene Extractor");



	}

	public void loadRecipes(){
		GameRegistry.addRecipe(new ItemStack(needle), new Object[]{
			"XXX", "X X", " Y ", Character.valueOf('X'), Item.ingotIron, Character.valueOf('Y'), Item.ingotGold
		});
		GameRegistry.addRecipe(new ItemStack(testTube, 2), new Object[]{
			"X X", "X X", "XXX", Character.valueOf('X'), Block.thinGlass
		});

		GameRegistry.addRecipe(new ItemStack(testTube, 6), new Object[]{
			"X X", "X X", "XXX", Character.valueOf('X'), Block.glass
		});

		GameRegistry.addRecipe(new ItemStack(centrifuge), new Object[]{
			"XYX", "YDY", "XYX", Character.valueOf('X'), Block.pistonBase, Character.valueOf('Y'), Item.ingotIron, Character.valueOf('D'), Item.diamond
		});
		GameRegistry.addRecipe(new ItemStack(sterilizer), new Object[]{
			"X X", "XYX", "XZX", Character.valueOf('X'), Item.ingotIron, Character.valueOf('Y'), Item.bucketEmpty, Character.valueOf('Z'), Item.redstone
		});
		GameRegistry.addRecipe(new ItemStack(lifeInducer), new Object[]{
			"XWX", "XYX", "XZX", Character.valueOf('W'), Item.ingotGold, Character.valueOf('X'), Item.ingotIron, Character.valueOf('Y'), Block.slowSand, 
			Character.valueOf('Z'), Block.chest
		});
		GameRegistry.addRecipe(new ItemStack(antenna, 9), new Object[]{
			"XYX", "XYX", "XYX", Character.valueOf('X'), Item.ingotIron, Character.valueOf('Y'), Item.ingotGold
		});
		//Ink, Slime, furnace, diamond, iron, gold
		GameRegistry.addRecipe(new ItemStack(dnaSequencer), new Object[]{
			"ABA", "ACA", "ADA", 
			Character.valueOf('A'), Item.ingotIron, 
			Character.valueOf('B'), new ItemStack(Item.dyePowder, 1, 0), 
			Character.valueOf('C'), Item.slimeBall, 
			Character.valueOf('D'), Block.furnaceIdle, 
		});
		GameRegistry.addRecipe(new ItemStack(geneExtractor), new Object[]{
			"ABC", "BDB", "EFG", 
			Character.valueOf('A'), Item.flint, 
			Character.valueOf('B'), Item.redstone, 
			Character.valueOf('C'), Item.bucketEmpty, 
			Character.valueOf('D'), Block.blockIron, 
			Character.valueOf('E'), new ItemStack(needle, 1, 0), 
			Character.valueOf('F'), Item.diamond, 
			Character.valueOf('G'), Block.furnaceIdle
		});
		//Flint, Bucket, Needle, Redstone, Diamond, Furnace, IronBlock
		GameRegistry.addShapelessRecipe(new ItemStack(emptyEgg), new Object[]{
			Item.egg
		});

		GameRegistry.registerCraftingHandler(new CloneCraftCraftingHandler());

		GameRegistry.addRecipe(new RecipeNeedleTestTubeRecipe());
		GameRegistry.addRecipe(new RecipeTestTubeNeedle());
		GameRegistry.addRecipe(new RecipeClearDNAItem());
		GameRegistry.addRecipe(new RecipeEmptyEggToSpawnEgg());
		GameRegistry.addRecipe(new RecipeAddGenes());
		GameRegistry.addRecipe(new RecipeGeneDNA());
		GameRegistry.addRecipe(new RecipeMutateSerum());
		GameRegistry.addRecipe(new RecipeAddGeneToSerum());
	}

	public static Config config = null;

	@EventHandler
	public void preInit(FMLPreInitializationEvent event){
		config = new Config(event.getSuggestedConfigurationFile());

		loadItems();
		loadBlocks();

		proxy.load(this);
	}

	@EventHandler
	public void init(FMLInitializationEvent event){
		NetworkRegistry.instance().registerChatListener(new ChatListener());
		loadRecipes();

		//Do Something



	}

	@EventHandler
	public void postInit(FMLPostInitializationEvent event){
		proxy.postInit();
	}

	HashMap<String, GeneEntry> playerToGenes = new HashMap<String, GeneEntry>();

	@EventHandler
	public void serverStarted(FMLServerStartedEvent event){
		playerToGenes.clear();
		File file = getServerFile();
		if(file != null){
			File theFile = new File(file, "CloneCraftPlayerGenes.dat");
			if(!theFile.exists())return;
			try {
				NBTTagCompound nbt = CompressedStreamTools.readCompressed(new FileInputStream(theFile));
				if(nbt != null){
					readNBT(nbt);
				}
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	public void writeNBT(NBTTagCompound nbt){
		NBTTagList list = new NBTTagList();
		for(Entry<String, GeneEntry> entry : playerToGenes.entrySet()){
			NBTTagCompound nbtEntry = new NBTTagCompound();
			nbtEntry.setString("PlayerName", entry.getKey());

			GeneEntry value = entry.getValue();

			nbtEntry.setIntArray("GeneIds", value.geneIds);
			nbtEntry.setIntArray("GeneStrengths", value.strengths);
			list.appendTag(nbtEntry);
		}
		nbt.setTag("Data", list);
	}

	public void readNBT(NBTTagCompound nbt){
		NBTTagList list = nbt.getTagList("Data");
		for(int a = 0; a < list.tagCount(); a++){
			NBTTagCompound entry = (NBTTagCompound)list.tagAt(a);
			String name = entry.getString("PlayerName");

			int[] geneIds = entry.getIntArray("GeneIds");
			int[] strengths = entry.getIntArray("GeneStrengths");

			playerToGenes.put(name , new GeneEntry(geneIds, strengths));
		}
	}



	@EventHandler
	public void serverStopping(FMLServerStoppingEvent event){
		File file = getServerFile();
		if(file != null){
			File theFile = new File(file, "CloneCraftPlayerGenes.dat");
			NBTTagCompound nbt = new NBTTagCompound();
			writeNBT(nbt);
			try {
				CompressedStreamTools.writeCompressed(nbt, new FileOutputStream(theFile));
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		playerToGenes.clear();
	}

	public class GeneEntry{

		int[] geneIds;
		int[] strengths;

		public GeneEntry(int[] geneIds, int[] geneStrengths){
			this.geneIds = geneIds;
			this.strengths = geneStrengths;
		}

		public void loadIntoPlayer(EntityPlayer player) {
			EntityLivingBase mutate = player;
			for(int a = 0; a < geneIds.length; a++){
				Gene gene = Gene.getGene(geneIds[a]);
				if(gene != null){
					mutate = gene.mutateLivingEntity(mutate, strengths[a]);
				}
			}
		}


	}

	public File getServerFile(){
		if(MinecraftServer.getServer() != null){
			if(MinecraftServer.getServer().worldServers != null){
				if(MinecraftServer.getServer().worldServers.length > 0){
					return MinecraftServer.getServer().worldServers[0].getChunkSaveLocation();
				}
			}
		}
		return null;
	}

	@Instance
	public static CloneCraft instance;

	public static boolean isDebugMode(){
		return CloneCraft.instance.config.DEBUG_ENABLED;
	}

	public void removePlayerGenes(String name){
		playerToGenes.remove(name);
	}

	public void onGenesChanged(CCEntityPlayerMP entity) {
		String name = entity.username;

		int size = entity.getGenePool().geneToLevel.size();

		int[] ids = new int[size];
		int[] strengths = new int[size];
		int pos = 0;
		for(Entry<Gene, Integer> entry : entity.getGenePool().geneToLevel.entrySet()){
			ids[pos] = entry.getKey().getId();
			strengths[pos] = entry.getValue();
			pos++;
		}
		playerToGenes.put(name, new GeneEntry(ids, strengths));
	}

	public void loadGenesIntoPlayer(EntityPlayer player){
		GeneEntry entry = playerToGenes.get(player.username);
		if(entry != null){
			entry.loadIntoPlayer(player);
		}
	}
	
	
	
	ArrayList<Entity> spawnAfter1Tick = new ArrayList<Entity>();
	
	public void spawnEntityAfterOneTick(Entity e){
		spawnAfter1Tick.add(e);
	}

	public void spawnEntitiesAfterTick() {
		for(int a = 0; a < spawnAfter1Tick.size(); a++){
			spawnAfter1Tick.get(a).worldObj.spawnEntityInWorld(spawnAfter1Tick.get(a));
		}
		spawnAfter1Tick.clear();
	}
}










//Looks cool:
/*
 * float scale = (((float)par1EntityLivingBase.hurtTime) / ((float)par1EntityLivingBase.maxHurtTime));
                    GL11.glColor4f(f14, 0.0F, 0.0F, scale*0.8F);
 */
